/*	cpmfio.h	1.5	83/05/13	*/

#ifndef CPMFIO_H
#define CPMFIO_H

typedef struct	c_iobuf {
    int			c_cnt;		/* bytes left in buffer */
    int			c_blk;		/* block number within the current extent */
				        /* (starting at 0) */
    int			c_seccnt;	/* number of physical sectors left in */
				        /* the current extent */
    int			c_ext;		/* current extent's directory index */
    int			c_extno;	/* extent number within current file */
    char		*c_buf;		/* next character position */
    char		*c_base;	/* location of buffer */
    short		c_flag;		/* access mode (READ or WRITE) */
    struct directory	*c_dirp;	/* pointer to the current */
					/* extent's directory entry */
    struct cpmfs	*cpmfs;		/* back pointer to CPM fs	*/

}	C_FILE;

#define c_getc(p)	(--(p)->c_cnt>=0 ? *(p)->c_buf++&0377 : cpm_file_fillbuf(p))
#define c_putc(x,p)	(--(p)->c_cnt>=0 ? ((int)(*(p)->c_buf++=(unsigned)(x))) : cpm_file_flsbuf((unsigned)(x), p))

C_FILE	*cpm_file_open(struct cpmfs *, char *, char *, int);
C_FILE	*cpm_file_creat(struct cpmfs *, char *, char *, int);

#define READ	0x01
#define WRITE	0x02
#define RW	0x03
#define MODFLG	0x08
#define BINARY	0x10

#endif
